#ifndef __Midi__
#define __Midi__

/**
 * @file Midi.h
 * @brief Single include for the Exponent Midi namespace
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Midi.h,v 1.5 2007/02/08 21:08:09 paul Exp $
 */

#include "CMidi.hpp"
#include "CMidiEvent.hpp"
#include "CMidiEventList.hpp"
#include "CMidiFile.hpp"
#include "CMidiSequence.hpp"
#include "CMidiTrack.hpp"

/**
 * @namespace Exponent::Midi
 * @brief Midi processing namespace
 *
 * Midi events, handlers and definitions
 */

//	===========================================================================
#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Midi;
#endif

#endif	// End of Midi.h